'use client'

import { verifyPutmeFeePayment } from "@/app/utils/app";
import { useRouter, useSearchParams } from "next/navigation";
import { useEffect, useRef, useState } from "react";
import Preloader from "@/app/Preloader";
import { notify } from "@/app/utils/helper";

const page = () => {
    const searchParams = useSearchParams();
    const reference = searchParams.get('reference');
    const fee_id = searchParams.get('fee_id');
    // Use a more descriptive status state: 'idle', 'loading', 'success', 'error'
    const [status, setStatus] = useState('idle'); 
    const router = useRouter();
    const ref = useRef(true);

    useEffect(() => {
        const verify = async () => {
            setStatus('loading'); // Indicate that verification is in progress
            try {
                const verification = await verifyPutmeFeePayment(fee_id, reference);
                if (verification.success) {
                    setStatus('success'); // Verification succeeded
                } else {
                    setStatus('error'); // Verification failed but no exception was thrown
                }
            } catch (error) {
                console.log(error);
                setStatus('error'); // Verification failed with an exception
                if (error.response?.data?.errors) {
                    notify('error', error.response.data.message);
                } else {
                    notify('error', error.message);
                }
            }
        };

        if(ref.current) verify();

        return () => ref.current = false;
    }, [reference]);

    useEffect(() => {
        if (status === 'success') {
            notify('success', 'Payment successful');
            router.replace('/aspirant/nid/login');
        } else if (status === 'error') {
            notify('error', 'Verification failed');
        }
    }, [status]);



    
    if (status === 'loading') {
        return <Preloader />;
    }

    return (
        <div>
            {status === 'error' ? <p>Verification failed</p> : null}
        </div>
    );
}

export default page;

